/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui.screen.edit;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Policy;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.Localization;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorScreen
extends Screen {
    private final Screen lastScreen;
    private final AbstractContainerScreen<?> underlay;
    private final LinkedList<TriggerButton> buttons = new LinkedList();
    public final Set<Integer> ignoredSlots = new TreeSet<Integer>();
    private TriggerButton rep;
    private String lowestPolicyKey;
    private boolean dragging;

    public EditorScreen(AbstractContainerScreen<?> underlay, TriggerButton button) {
        this(underlay, button, (Screen)underlay);
    }

    public EditorScreen(AbstractContainerScreen<?> underlay, TriggerButton button, Screen lastScreen) {
        super((Component)Localization.localized("title", "positionEditor", new Object[0]));
        this.font = Minecraft.getInstance().font;
        this.lastScreen = lastScreen;
        this.underlay = underlay;
        this.rep = button;
        this.buttons.add(button);
    }

    public void init() {
        super.init();
        this.underlay.init(Minecraft.getInstance(), this.width, this.height);
        if (!this.reloadButtonsAndIgnoredSlots()) {
            this.clearWidgets();
            return;
        }
        this.rebuildGui();
    }

    private boolean reloadButtonsAndIgnoredSlots() {
        this.buttons.clear();
        this.ignoredSlots.clear();
        this.buttons.addAll(this.getButtons());
        if (this.buttons.size() != 3) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.error("Failed to reload buttons on PositionEditScreen: Button list is too small (expected: {}, actual: {})", 3, this.buttons.size());
            }
            return false;
        }
        this.rep = this.buttons.getFirst();
        ClassPolicy policy = Config.options().classPolicies.get(this.rep.activePolicyKey);
        if (policy != null) {
            this.buttons.forEach(button -> {
                button.active = button.getPolicyStatus(policy);
            });
            this.ignoredSlots.addAll(policy.ignoredSlots());
        }
        AbstractContainerMenu keyObject = this.rep.container instanceof SimpleContainer ? this.underlay.getMenu() : this.rep.container;
        this.lowestPolicyKey = keyObject.getClass().getName();
        return true;
    }

    protected abstract LinkedList<TriggerButton> getButtons();

    private void rebuildGui() {
        this.clearWidgets();
        Objects.requireNonNull(this.font);
        StringWidget titleWidget = new StringWidget(0, 2, this.width, 9, this.title, this.font);
        this.addRenderableWidget((GuiEventListener)titleWidget);
        int numButtons = 10;
        int x = 2;
        int movingY = this.height - 21 * numButtons;
        int width = 100;
        int height = 20;
        Button instructionsButton = Button.builder((Component)Localization.localized("editor", "instructions", new Object[0]), button -> {}).tooltip(Tooltip.create((Component)Localization.localized("editor", "instructions.tooltip.1", new Object[0]).append("\n\n").append((Component)Localization.localized("editor", "instructions.tooltip.2", new Object[0])).append("\n\n").append((Component)Localization.localized("editor", "instructions.tooltip.3", new Object[0])).append("\n\n").append((Component)Localization.localized("editor", "instructions.tooltip.4", new Object[0])).append("\n\n").append((Component)Localization.localized("editor", "instructions.tooltip.5", new Object[0])))).pos(x, movingY).size(width, height).build();
        instructionsButton.active = false;
        this.addRenderableWidget((GuiEventListener)instructionsButton);
        Button toggleVisibilityButton = Button.builder((Component)Localization.localized("editor", "toggleVisibility", new Object[0]), button -> {
            boolean status = this.buttons.stream().noneMatch(b -> b.active);
            this.buttons.forEach(b -> {
                b.active = status;
            });
        }).tooltip(Tooltip.create((Component)Localization.localized("editor", "toggleVisibility.tooltip", new Object[0]))).pos(x, movingY += 21).size(width, height).build();
        this.addRenderableWidget((GuiEventListener)toggleVisibilityButton);
        Button unignoreSlotsButton = Button.builder((Component)Localization.localized("editor", "unignoreSlots", new Object[0]), button -> this.ignoredSlots.clear()).tooltip(Tooltip.create((Component)Localization.localized("editor", "unignoreSlots.tooltip", new Object[0]))).pos(x, movingY += 21).size(width, height).build();
        this.addRenderableWidget((GuiEventListener)unignoreSlotsButton);
        Button moveToDefaultButton = Button.builder((Component)Localization.localized("editor", "moveToDefault", new Object[0]), button -> {
            Vec2i before = this.buttons.getFirst().offset;
            this.buttons.getFirst().offset = Config.options().layoutOffset;
            this.repositionButtons(this.buttons.getFirst(), before);
        }).tooltip(Tooltip.create((Component)Localization.localized("editor", "moveToDefault.tooltip", new Object[0]))).pos(x, movingY += 21).size(width, height).build();
        this.addRenderableWidget((GuiEventListener)moveToDefaultButton);
        Button saveAsDefaultButton = Button.builder((Component)Localization.localized("editor", "saveAsDefault", new Object[0]), button -> Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(confirm -> {
            if (confirm) {
                Config.options().layoutOffset = this.buttons.getFirst().offset;
                Config.save();
                this.init();
            }
            Minecraft.getInstance().setScreen((Screen)this);
        }, (Component)Localization.localized("title", "confirm.saveAsDefault", new Object[0]), (Component)Localization.localized("message", "confirm.saveAsDefault", new Object[0])))).tooltip(Tooltip.create((Component)Localization.localized("editor", "saveAsDefault.tooltip", new Object[0]))).pos(x, movingY += 21).size(width, height).build();
        this.addRenderableWidget((GuiEventListener)saveAsDefaultButton);
        Button splitPolicyButton = Button.builder((Component)Localization.localized("editor", "splitPolicy", new Object[0]), button -> Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(confirm -> {
            if (confirm) {
                Config.options().classPolicies.put(this.lowestPolicyKey, new ClassPolicy(this.lowestPolicyKey, this.buttons.getFirst().offset, this.buttons.getFirst().operationAllowed ? (this.buttons.getFirst().active ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, this.buttons.get((int)1).operationAllowed ? (this.buttons.getFirst().active ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, this.buttons.get((int)2).operationAllowed ? (this.buttons.getFirst().active ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, new TreeSet<Integer>(this.ignoredSlots)));
                Config.save();
                this.init();
            }
            Minecraft.getInstance().setScreen((Screen)this);
        }, (Component)Localization.localized("title", "confirm.splitPolicy", new Object[0]), (Component)Localization.localized("message", "confirm.splitPolicy", Component.literal((String)(this.rep.activePolicyKey == null ? this.lowestPolicyKey : this.rep.activePolicyKey)).withStyle(ChatFormatting.GOLD), Component.literal((String)this.lowestPolicyKey).withStyle(ChatFormatting.GOLD))))).tooltip(Tooltip.create((Component)Localization.localized("editor", "splitPolicy.tooltip", new Object[0]))).pos(x, movingY += 21).size(width, height).build();
        splitPolicyButton.active = this.rep.activePolicyKey != null && !this.rep.activePolicyKey.equals(this.lowestPolicyKey);
        this.addRenderableWidget((GuiEventListener)splitPolicyButton);
        Button undoChangesButton = Button.builder((Component)Localization.localized("editor", "undoChanges", new Object[0]), button -> this.init()).tooltip(Tooltip.create((Component)Localization.localized("editor", "undoChanges.tooltip", new Object[0]))).pos(x, movingY += 21).size(width, height).build();
        this.addRenderableWidget((GuiEventListener)undoChangesButton);
        Button reselectButton = Button.builder((Component)Localization.localized("editor", "reselect", new Object[0]), button -> {
            this.onClose();
            Minecraft.getInstance().setScreen((Screen)new SelectorScreen(this.underlay, this));
        }).tooltip(Tooltip.create((Component)Localization.localized("editor", "reselect.tooltip", new Object[0]))).pos(x, movingY += 21).size(width, height).build();
        this.addRenderableWidget((GuiEventListener)reselectButton);
        Button cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).pos(x, movingY += 21).size(width, height).build();
        this.addRenderableWidget((GuiEventListener)cancelButton);
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.saveAndClose()).pos(x, movingY += 21).size(width, height).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.underlay.render(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        for (int slotId : this.ignoredSlots) {
            Slot slot = (Slot)this.underlay.getMenu().slots.get(slotId);
            graphics.drawString(Minecraft.getInstance().font, "\u274c", ((AbstractContainerScreenAccessor)this.underlay).clientsort$getLeftPos() + slot.x, ((AbstractContainerScreenAccessor)this.underlay).clientsort$getTopPos() + slot.y, 0xFF0000);
        }
        if (this.buttons.isEmpty()) {
            return;
        }
        this.drawLineFor(graphics, this.buttons.getFirst());
        Vec2i offset = this.buttons.getFirst().offset;
        String string = Localization.localized("editor", "offset", offset.x(), offset.y()).getString();
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, string, 105, this.height - (9 + 1) * 3, -1);
        MutableComponent mutableComponent = Localization.localized("editor", "policyKey.current", this.rep.activePolicyKey == null ? Localization.localized("editor", "policyKey.unset", new Object[0]) : this.rep.activePolicyKey);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, (Component)mutableComponent, 105, this.height - (9 + 1) * 2, -1);
        MutableComponent mutableComponent2 = Localization.localized("editor", "policyKey.menu", this.lowestPolicyKey);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, (Component)mutableComponent2, 105, this.height - (9 + 1), -1);
        for (TriggerButton cb : this.buttons) {
            cb.renderWidget(graphics, mouseX, mouseY, partialTick);
        }
    }

    protected void renderBlurredBackground(float partialTick) {
        int original = (Integer)Minecraft.getInstance().options.menuBackgroundBlurriness().get();
        Minecraft.getInstance().options.menuBackgroundBlurriness().set((Object)1);
        super.renderBlurredBackground(partialTick);
        Minecraft.getInstance().options.menuBackgroundBlurriness().set((Object)original);
    }

    private void drawLineFor(GuiGraphics graphics, TriggerButton button) {
        graphics.hLine(button.getX() - button.offset.x(), button.getX(), button.getY(), -4473925);
        graphics.vLine(button.getX() - button.offset.x(), button.getY() - button.offset.y(), button.getY(), -4473925);
    }

    public void onClose() {
        super.onClose();
        this.lastScreen.init(Minecraft.getInstance(), this.width, this.height);
        Minecraft.getInstance().setScreen(this.lastScreen);
    }

    public void saveAndClose() {
        @Nullable Vec2i offset = this.buttons.getFirst().offset.equals(Config.options().layoutOffset) ? null : this.buttons.getFirst().offset;
        this.buttons.forEach(b -> b.savePolicy(offset, this.ignoredSlots));
        Config.save();
        this.onClose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Vec2i movement;
        int distance = Screen.hasShiftDown() ? 6 : 1;
        switch (keyCode) {
            case 263: {
                Vec2i vec2i = new Vec2i(-distance, 0);
                break;
            }
            case 262: {
                Vec2i vec2i = new Vec2i(distance, 0);
                break;
            }
            case 265: {
                Vec2i vec2i = new Vec2i(0, -distance);
                break;
            }
            case 264: {
                Vec2i vec2i = new Vec2i(0, distance);
                break;
            }
            default: {
                Vec2i vec2i = movement = null;
            }
        }
        if (movement != null) {
            Vec2i before = this.rep.offset;
            this.rep.offset = this.rep.offset.add(movement);
            this.repositionButtons(this.rep, before);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.dragging = false;
            return true;
        }
        for (TriggerButton cb : this.buttons) {
            if (!cb.isMouseOver(mouseX, mouseY)) continue;
            cb.mouseClicked(mouseX, mouseY, mouseButton);
            this.rep = cb;
            this.dragging = true;
            return true;
        }
        for (Slot slot : this.underlay.getMenu().slots) {
            Container object;
            if (!((AbstractContainerScreenAccessor)this.underlay).clientsort$isHovering(slot, mouseX, mouseY) || !(object = slot.container instanceof SimpleContainer ? this.underlay.getMenu() : slot.container).getClass().getName().equals(this.lowestPolicyKey)) continue;
            int slotId = ((ISlot)slot).clientsort$getIdInContainer();
            if (this.ignoredSlots.contains(slotId)) {
                this.ignoredSlots.remove(slotId);
                continue;
            }
            this.ignoredSlots.add(slotId);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            Vec2i before = this.rep.offset;
            if (this.rep.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
                this.repositionButtons(this.rep, before);
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    private void repositionButtons(TriggerButton button, Vec2i before) {
        if (!button.offset.equals(before)) {
            Vec2i diff = button.offset.subtract(before);
            for (TriggerButton cb : this.buttons) {
                if (cb == button) continue;
                cb.offset = cb.offset.add(diff);
            }
        }
    }
}

